# Minimal Attendance System

Simple 2-file attendance tracking system for Hikvision DS-K1T320EFWX devices.

## 📁 Files

1. **index.php** - Dashboard to view attendance
2. **webhook.php** - Receives data from device
3. **attendance.json** - Auto-generated data storage

## 🚀 Quick Setup

### 1. Upload Files

Upload to your server:
```
/public_html/attendance100/
├── index.php
├── webhook.php
└── attendance.json (auto-created)
```

### 2. Set Permissions

```bash
chmod 755 attendance100/
chmod 644 index.php webhook.php
chmod 666 attendance.json  # Or will be auto-created
```

### 3. Configure Hikvision Device

#### Access Device:
```
https://192.168.1.73/doc/index.html
```

#### Navigate To:
```
Configuration → Network → Advanced → HTTP Listening
```

#### Settings:
- **HTTPS**: Enabled (Port 443)
- **Event Alarm IP/Domain**: `dev.ntranepal.edu.np`
- **URL**: `/attendance100/webhook.php`
- **Port**: `443` (or `80` for HTTP)
- **Method**: `POST`

Click **Save**

### 4. Add Employees to Device

#### Access Person Management:
```
https://192.168.1.73/doc/index.html#/peopleManage
```

#### Add Person:
- **Employee ID**: `emp115275` (staff) or `stu12345` (students)
- **Name**: Full name
- **Enroll**: Card/Fingerprint/Face

#### Employee ID Format:
- Staff: `empXXXXX` (e.g., `emp115275`)
- Students: `stuXXXXX` (e.g., `stu12345`)

### 5. Test

1. Tap card on device
2. Open: `https://dev.ntranepal.edu.np/attendance100/`
3. Check if attendance appears

## 🔧 How It Works

```
Employee taps device
        ↓
Device sends POST to webhook.php
        ↓
webhook.php validates & saves to attendance.json
        ↓
index.php reads & displays attendance
```

## 📊 Attendance Logic

- **emp*** → Staff attendance
- **stu*** (before 12 PM) → Student In
- **stu*** (after 12 PM) → Student Out

## 🐛 Troubleshooting

### No attendance appearing?
1. Check file exists: `attendance.json`
2. Check permissions: `chmod 666 attendance.json`
3. Test webhook directly:
   ```bash
   curl -X POST https://dev.ntranepal.edu.np/attendance100/webhook.php \
     -d 'event_log={"dateTime":"2026-01-03T14:30:00","ipAddress":"192.168.1.73","AccessControllerEvent":{"majorEventType":5,"subEventType":75,"employeeNoString":"emp999"}}'
   ```

### Device not sending data?
- Verify device can reach internet
- Check domain resolves correctly
- Verify URL setting: `/attendance100/webhook.php`
- Check device network settings

## 📝 Manual Test

Create `test.php`:
```php
<?php
$data = [
    'event_log' => json_encode([
        'dateTime' => date('Y-m-d\TH:i:s'),
        'ipAddress' => '192.168.1.73',
        'macAddress' => 'a4:d5:c2:14:dd:73',
        'AccessControllerEvent' => [
            'majorEventType' => 5,
            'subEventType' => 75,
            'employeeNoString' => 'emp999'
        ]
    ])
];

$ch = curl_init('http://localhost/attendance100/webhook.php');
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

echo $response;
```

Run: `php test.php`

## 🔐 Production Tips

1. **Backup attendance.json regularly**
   ```bash
   cp attendance.json backup-$(date +%Y%m%d).json
   ```

2. **Enable device validation** (add to webhook.php):
   ```php
   $allowedDevices = ['192.168.1.73'];
   if (!in_array($deviceIp, $allowedDevices)) {
       die(json_encode(['status' => 401, 'message' => 'Unauthorized']));
   }
   ```

3. **Add authentication** to index.php

4. **Monitor file size** (attendance.json auto-limits to 5000 records)

## 📦 That's It!

- **2 PHP files** for core functionality
- **1 JSON file** for data storage
- **No database required**
- **Ready to extend** with MVC later

---

**Deployment URL**: https://dev.ntranepal.edu.np/attendance100/  
**Webhook URL**: https://dev.ntranepal.edu.np/attendance100/webhook.php
